import { Injectable, OnInit } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import 'rxjs/add/operator/toPromise';

import { IAppState } from '../store';
import { environment } from '../../environments/environment';

@Injectable()
export class ApiServices implements OnInit {
  constructor(
    private http: Http,
    private ngRedux: NgRedux<IAppState>) {
  }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  apiUrl() {
    return this.getState().system.environment.apiUrl;
  }

  getHeader() {
    let headers = new Headers();
    headers.append('Accept', 'application/json');
    headers.append('Content-type', 'application/json');
    headers.append('Cache-Control', 'no-cache');
    headers.append('Pragma', 'no-cache');
    return headers;
  }

  async getEnvironment(): Promise<any> {
    try {
      if (environment.production) {
        let response = await this.http.get('help/env.json').toPromise();
        return response.text();
      } else {
        let response = await this.http.get('assets/env.json').toPromise();
        return response.text();
      }
    } catch (error) {
      console.log(error);
    }
  }
}